/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.cart.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import gz.lp.common.core.exception.ServiceException;
import gz.lp.common.core.utils.DateUtils;
import gz.lp.common.security.utils.SecurityUtils;
import gz.lp.mall.cart.entity.ShoppingCart;
import gz.lp.mall.cart.mapper.ShoppingCartMapper;
import gz.lp.mall.cart.service.ShoppingCartService;
import gz.lp.mall.product.entity.GoodsSku;
import gz.lp.mall.product.mapper.GoodsSkuMapper;
import gz.lp.system.api.domain.param.AddShoppingCartParams;
import gz.lp.system.api.domain.param.GetCartParam;
import gz.lp.system.api.domain.param.IdsParams;
import gz.lp.system.api.domain.vo.CartItemVo;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShoppingCartServiceImpl
extends ServiceImpl<ShoppingCartMapper, ShoppingCart>
implements ShoppingCartService {
    @Autowired
    private ShoppingCartMapper shoppingCartMapper;
    @Autowired
    private GoodsSkuMapper goodsSkuMapper;

    @Transactional(rollbackFor={Exception.class})
    public boolean addToCart(AddShoppingCartParams addCar) {
        ShoppingCart shoppingCart = new ShoppingCart();
        shoppingCart.setCreateTime(DateUtils.formatDate((String)DateUtils.getTime()));
        shoppingCart.setMemberId(SecurityUtils.getLoginUser().getMember().getId());
        shoppingCart.setProductId(addCar.getProductId());
        shoppingCart.setQuantity(addCar.getQuantity());
        shoppingCart.setStoreId(addCar.getStoreId());
        GoodsSku goodsSku = (GoodsSku)this.goodsSkuMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(GoodsSku.class).eq(GoodsSku::getSkuValueIds, (Object)addCar.getSkuValues())).eq(GoodsSku::getGoodsId, (Object)addCar.getProductId())).last(" limit 1"));
        if (goodsSku == null) {
            throw new ServiceException("\u5546\u54c1\u89c4\u683c\u4e0d\u5b58\u5728");
        }
        shoppingCart.setSpecId(goodsSku.getId());
        shoppingCart.setIsDel(Integer.valueOf(0));
        shoppingCart.setSkuValues(addCar.getSkuValues());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(ShoppingCart.class).eq(ShoppingCart::getMemberId, (Object)SecurityUtils.getLoginUser().getMember().getId())).eq(ShoppingCart::getProductId, (Object)addCar.getProductId())).eq(ShoppingCart::getSpecId, (Object)goodsSku.getId())).eq(ShoppingCart::getIsDel, (Object)0)).last("limit 1");
        ShoppingCart shoppingCart1 = (ShoppingCart)this.shoppingCartMapper.selectOne((Wrapper)wrapper);
        if (shoppingCart1 != null) {
            shoppingCart1.setQuantity(Integer.valueOf(shoppingCart1.getQuantity() + addCar.getQuantity()));
            return this.shoppingCartMapper.updateById((Object)shoppingCart1) > 0;
        }
        return this.shoppingCartMapper.insert((Object)shoppingCart) > 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateCartItem(AddShoppingCartParams editCarVo) {
        ShoppingCart shoppingCart = this.getByIdAndMid(editCarVo.getCartId(), SecurityUtils.getLoginUser().getMember().getId());
        if (shoppingCart == null) {
            throw new ServiceException("\u8d2d\u7269\u8f66\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        shoppingCart.setQuantity(editCarVo.getQuantity());
        if (ObjectUtil.notEqual((Object)shoppingCart.getSkuValues(), (Object)editCarVo.getSkuValues())) {
            GoodsSku goodsSku = (GoodsSku)this.goodsSkuMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(GoodsSku.class).eq(GoodsSku::getSkuValueIds, (Object)editCarVo.getSkuValues())).eq(GoodsSku::getGoodsId, (Object)shoppingCart.getProductId())).last(" limit 1"));
            if (goodsSku == null) {
                throw new ServiceException("\u5546\u54c1\u89c4\u683c\u4e0d\u5b58\u5728");
            }
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(ShoppingCart.class).eq(ShoppingCart::getMemberId, (Object)SecurityUtils.getLoginUser().getMember().getId())).eq(ShoppingCart::getProductId, (Object)shoppingCart.getProductId())).eq(ShoppingCart::getSpecId, (Object)goodsSku.getId())).eq(ShoppingCart::getIsDel, (Object)0)).last("limit 1");
            ShoppingCart shoppingCart1 = (ShoppingCart)this.shoppingCartMapper.selectOne((Wrapper)wrapper);
            if (shoppingCart1 != null) {
                this.shoppingCartMapper.deleteById((Serializable)shoppingCart.getId());
                shoppingCart1.setQuantity(Integer.valueOf(shoppingCart1.getQuantity() + editCarVo.getQuantity()));
                return this.shoppingCartMapper.updateById((Object)shoppingCart1) > 0;
            }
            shoppingCart.setSpecId(goodsSku.getId());
            shoppingCart.setSkuValues(editCarVo.getSkuValues());
        }
        return this.shoppingCartMapper.updateById((Object)shoppingCart) > 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean deleteCartItem(IdsParams params) {
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper(ShoppingCart.class).set(ShoppingCart::getIsDel, (Object)1)).in(ShoppingCart::getId, (Collection)params.getIds());
        return this.shoppingCartMapper.update(null, (Wrapper)wrapper) > 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean clearCart() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper(ShoppingCart.class);
        wrapper.eq(ShoppingCart::getMemberId, (Object)SecurityUtils.getLoginUser().getMember().getId());
        return this.remove((Wrapper)wrapper);
    }

    public ShoppingCart getByIdAndMid(Integer shoppingCartId, Integer mid) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper(ShoppingCart.class);
        wrapper.eq(ShoppingCart::getId, (Object)shoppingCartId);
        wrapper.eq(ShoppingCart::getMemberId, (Object)mid);
        wrapper.eq(ShoppingCart::getIsDel, (Object)0);
        return (ShoppingCart)this.shoppingCartMapper.selectOne((Wrapper)wrapper);
    }

    public boolean deleteCartByIds(List<Integer> cartIdList) {
        return this.shoppingCartMapper.deleteBatchIds(cartIdList) > 0;
    }

    public IPage<CartItemVo> getCartList(GetCartParam param) {
        param.setMemberId(SecurityUtils.getLoginUser().getMember().getId());
        Page page = new Page((long)param.getPageNo().intValue(), (long)param.getPageSize().intValue());
        return this.shoppingCartMapper.getCartList(page, param.getMemberId(), param.getKeyWord());
    }
}

