/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.mall.cache;

import gz.lp.mall.cache.PageCache;
import gz.lp.mall.cache.PageResult;
import gz.lp.system.api.param.QueryGoodsParam;
import gz.lp.system.api.vo.AppletGoodsListVo;
import gz.lp.system.api.vo.PriceWithPointsVo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.DigestUtils;

public class CacheTools {
    public static String generateCacheKey(QueryGoodsParam params) {
        String paramsString = String.format("%s|%s|%s|%s|%d|%d", params.getCategoryId() != null ? params.getCategoryId() : Integer.valueOf(0), params.getGoodName() != null ? params.getGoodName() : "", params.getSalesNum() != null ? params.getSalesNum() : "desc", params.getPrice() != null ? params.getPrice() : "desc", params.getPageNo(), params.getPageSize());
        return "goods:cache:" + DigestUtils.md5DigestAsHex((byte[])paramsString.getBytes());
    }

    public static List<AppletGoodsListVo> convertToVO(List<AppletGoodsListVo> goodsList) {
        return goodsList.stream().map(g -> {
            AppletGoodsListVo vo = new AppletGoodsListVo();
            vo.setId(g.getId());
            vo.setName(g.getName());
            vo.setImage(g.getImage());
            vo.setVirtualSalesNum(g.getVirtualSalesNum());
            vo.setMinPrice(g.getMinPrice());
            vo.setPrice(g.getPrice());
            return vo;
        }).collect(Collectors.toList());
    }

    public static PriceWithPointsVo calculate(BigDecimal originalPrice, int ratio) {
        BigDecimal cash = originalPrice.multiply(BigDecimal.ONE.subtract(new BigDecimal(ratio).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP))).setScale(2, RoundingMode.HALF_UP);
        int points = originalPrice.multiply(new BigDecimal(ratio).divide(BigDecimal.TEN, 2, RoundingMode.HALF_UP)).intValue();
        PriceWithPointsVo priceWithPointsVo = new PriceWithPointsVo();
        priceWithPointsVo.setPoints(points);
        priceWithPointsVo.setCash(cash);
        return priceWithPointsVo;
    }

    public static PageResult<AppletGoodsListVo> buildPageResult(PageCache cache, QueryGoodsParam params) {
        return new PageResult(cache.getData(), params.getPageNo(), params.getPageSize(), Long.valueOf(cache.getTotal()));
    }
}

