/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.file.storage.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.file.FileNameUtil;
import gz.lp.file.storage.properties.StorageProperties;
import java.io.InputStream;
import java.util.Date;
import org.springframework.util.StringUtils;

public abstract class StorageService {
    public StorageProperties properties;

    public String getNewFileName(String fileName) {
        String prefix = FileNameUtil.getPrefix((String)fileName);
        String suffix = FileNameUtil.getSuffix((String)fileName);
        long time = DateUtil.timeToSecond((String)DateUtil.formatTime((Date)new Date()));
        return prefix + "_" + time + "." + suffix;
    }

    public String getPath() {
        Object path = DateUtil.format((Date)new Date(), (String)"yyyyMMdd");
        if (StringUtils.hasText((String)this.properties.getConfig().getPrefix())) {
            path = this.properties.getConfig().getPrefix() + "/" + (String)path;
        }
        return path;
    }

    public String getPath(String fileName) {
        return this.getPath() + "/" + this.getNewFileName(fileName);
    }

    public abstract String upload(byte[] var1, String var2);

    public abstract String upload(InputStream var1, String var2);
}

