/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.file.storage.config;

import gz.lp.file.storage.enums.StorageTypeEnum;
import gz.lp.file.storage.properties.StorageProperties;
import gz.lp.file.storage.service.LocalStorageService;
import gz.lp.file.storage.service.QiniuStorageService;
import gz.lp.file.storage.service.StorageService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={StorageProperties.class})
@ConditionalOnProperty(prefix="storage", value={"enabled"})
public class StorageConfig {
    @Bean
    public StorageService storageService(StorageProperties properties) {
        if (properties.getConfig().getType() == StorageTypeEnum.LOCAL) {
            return new LocalStorageService(properties);
        }
        if (properties.getConfig().getType() == StorageTypeEnum.QINIU) {
            return new QiniuStorageService(properties);
        }
        return null;
    }
}

