/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.file.controller;

import gz.lp.common.core.api.R;
import gz.lp.common.core.exception.ServiceException;
import gz.lp.file.service.ISysFileService;
import gz.lp.file.storage.service.StorageService;
import gz.lp.file.utils.FileUploadUtils;
import gz.lp.system.api.domain.FileUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class SysFileController {
    private static final Logger log = LoggerFactory.getLogger(SysFileController.class);
    @Autowired
    private ISysFileService sysFileService;
    @Autowired
    private StorageService storageService;

    @PostMapping(value={"upload"})
    public R<FileUrl> upload(MultipartFile file) {
        String path = FileUploadUtils.resetFileName((MultipartFile)file);
        try {
            FileUrl fileUrl = new FileUrl();
            String upload = this.storageService.upload(file.getInputStream(), path);
            fileUrl.setQlyURL(upload);
            int lastSlashIndex = upload.lastIndexOf(47);
            int lastDotIndex = upload.lastIndexOf(46);
            String uuid = upload.substring(lastSlashIndex + 1, lastDotIndex);
            String url = this.sysFileService.uploadFile(file, uuid);
            fileUrl.setLocalURL(url);
            return R.ok((Object)fileUrl);
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25" + path);
        }
    }

    @PostMapping(value={"/del"})
    public R<String> del(String fileName) {
        return this.sysFileService.delFile(fileName) != false ? R.ok() : R.failed();
    }
}

