/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.applet.tribe.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import gz.lp.applet.tribe.dto.CommentDTO;
import gz.lp.applet.tribe.entity.Comments;
import gz.lp.applet.tribe.mapper.CommentsMapper;
import gz.lp.applet.tribe.param.QueryCommentsParam;
import gz.lp.applet.tribe.service.CommentsService;
import gz.lp.common.core.exception.ServiceException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommentsServiceImpl
extends ServiceImpl<CommentsMapper, Comments>
implements CommentsService {
    @Autowired
    private CommentsMapper commentMapper;

    public boolean addComment(Comments comment) {
        Comments parentComment;
        comment.setCreatedAt(new Date());
        if (comment.getParentId() != null && (parentComment = this.commentMapper.selectByP(comment.getParentId())) == null) {
            throw new ServiceException("\u7236\u8bc4\u8bba\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u56de\u590d");
        }
        return this.commentMapper.insert((Object)comment) > 0;
    }

    public IPage<CommentDTO> getCommentsByPostId(QueryCommentsParam queryCommentsParam) {
        Page Page2 = new Page((long)queryCommentsParam.getPageNo().intValue(), (long)queryCommentsParam.getPageSize().intValue());
        IPage commentDTOIPage = this.commentMapper.queryComments((IPage)Page2, queryCommentsParam);
        List records = commentDTOIPage.getRecords();
        List commentIds = records.stream().map(re -> re.getCommentId()).collect(Collectors.toList());
        if (commentIds.isEmpty()) {
            return null;
        }
        List comments = this.commentMapper.queryCommentForP(commentIds);
        Map<Integer, Long> num = comments.stream().collect(Collectors.groupingBy(Comments::getParentId, Collectors.counting()));
        HashMap integerStringMap = new HashMap();
        comments.stream().forEach(co -> {
            if (!integerStringMap.containsKey(co.getParentId())) {
                integerStringMap.put(co.getParentId(), co);
            }
        });
        records.stream().forEach(re -> {
            if (integerStringMap.containsKey(re.getCommentId())) {
                re.setChildren((Comments)integerStringMap.get(re.getCommentId()));
                re.setUnexpandedCount(Long.valueOf((Long)num.get(re.getCommentId()) - 1L));
            }
        });
        return commentDTOIPage;
    }

    public boolean deleteComment(Integer commentId) {
        Comments comment = (Comments)this.commentMapper.selectById((Serializable)commentId);
        if (comment == null) {
            throw new ServiceException("\u8bc4\u8bba\u4e0d\u5b58\u5728");
        }
        this.deleteReplies(commentId);
        return this.commentMapper.deleteById((Serializable)commentId) > 0;
    }

    public boolean updateComment(Comments comment) {
        Comments existingComment = (Comments)this.commentMapper.selectById((Serializable)comment.getCommentId());
        if (existingComment == null) {
            throw new ServiceException("\u8bc4\u8bba\u4e0d\u5b58\u5728");
        }
        existingComment.setContent(comment.getContent());
        return this.commentMapper.updateById((Object)existingComment) > 0;
    }

    private void deleteReplies(Integer parentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"parent_id", (Object)parentId);
        List replies = this.commentMapper.selectList((Wrapper)queryWrapper);
        for (Comments reply : replies) {
            this.deleteReplies(reply.getCommentId());
            this.commentMapper.deleteById((Serializable)reply.getCommentId());
        }
    }
}

