/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.auth.service;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import gz.lp.auth.service.SysRecordLogService;
import gz.lp.common.core.exception.ServiceException;
import gz.lp.common.redis.util.RedisUtil;
import gz.lp.common.security.utils.SecurityUtils;
import gz.lp.system.api.RemoteUserService;
import gz.lp.system.api.domain.SysUser;
import jakarta.annotation.PostConstruct;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class SysPasswordService {
    private int maxRetryCount = 500;
    private Long lockTime = 14400000L;
    @Value(value="classpath:configData.txt")
    private Resource configFile;
    @Autowired
    private SysRecordLogService recordLogService;
    @Autowired
    private RemoteUserService remoteUserService;

    @PostConstruct
    public void init() {
        this.getLockTime();
    }

    private String getCacheKey(String username) {
        return "pwd_err_cnt:" + username;
    }

    public void validate(SysUser user, String password) {
        String username = user.getUserName();
        Integer retryCount = (Integer)RedisUtil.get((String)this.getCacheKey(username));
        if (retryCount == null) {
            retryCount = 0;
        }
        if (retryCount >= Integer.valueOf(this.maxRetryCount)) {
            String errMsg = String.format("\u5bc6\u7801\u8f93\u5165\u9519\u8bef%s\u6b21\uff0c\u5e10\u6237\u9501\u5b9a%s\u5206\u949f", this.maxRetryCount, this.lockTime);
            this.recordLogService.recordLogininfor(username, "Error", errMsg);
            throw new ServiceException(errMsg);
        }
        if (!this.matches(user, password)) {
            retryCount = retryCount + 1;
            this.recordLogService.recordLogininfor(username, "Error", String.format("\u5bc6\u7801\u8f93\u5165\u9519\u8bef%s\u6b21", retryCount));
            RedisUtil.set((String)this.getCacheKey(username), (Object)retryCount, (long)this.lockTime);
            throw new ServiceException("\u7528\u6237\u4e0d\u5b58\u5728/\u5bc6\u7801\u9519\u8bef");
        }
        this.clearLoginRecordCache(username);
    }

    public boolean matches(SysUser user, String rawPassword) {
        return SecurityUtils.matchesPassword((String)rawPassword, (String)user.getPassword());
    }

    public void clearLoginRecordCache(String loginName) {
        if (RedisUtil.hasKey((String)this.getCacheKey(loginName)).booleanValue()) {
            RedisUtil.del((String[])new String[]{this.getCacheKey(loginName)});
        }
    }

    public String notLoginInFor90Days(String passUpdateTime) {
        Date nowTime = new Date();
        DateTime date = DateUtil.parse((CharSequence)passUpdateTime);
        DateTime newDate = DateUtil.offset((Date)date, (DateField)DateField.DAY_OF_MONTH, (int)90);
        if (nowTime.compareTo((Date)newDate) > 0) {
            return "\u5c0a\u656c\u7684\u7528\u6237,\u60a8\u7684\u8d26\u53f7\u8d85\u8fc790\u5929\u672a\u4fee\u6539\u5bc6\u7801\uff0c\u8bf7\u4fee\u6539\u5bc6\u7801\u540e\uff0c\u4f7f\u7528\u65b0\u7684\u5bc6\u7801\u767b\u5f55\uff01";
        }
        return null;
    }

    public String notLoginInFor30Days(Date loginDate, String username) {
        Date nowTime = new Date();
        DateTime newDate = DateUtil.offset((Date)loginDate, (DateField)DateField.DAY_OF_MONTH, (int)30);
        if (nowTime.compareTo((Date)newDate) > 0) {
            this.remoteUserService.freezing(username, "inner");
            return "\u5c0a\u656c\u7684\u7528\u6237,\u60a8\u7684\u8d26\u53f7:" + username + "\u5df2\u8d8530\u5929\u6ca1\u6709\u767b\u5f55\uff0c\u8d26\u53f7\u5df2\u7ecf\u505c\u7528,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\uff01";
        }
        return null;
    }

    public String[] readFileContent() {
        StringBuilder contentBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.configFile.getInputStream(), StandardCharsets.UTF_8));){
            String currentLine;
            while ((currentLine = reader.readLine()) != null) {
                contentBuilder.append(currentLine).append("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return contentBuilder.toString().split("\n");
    }

    public void getLockTime() {
        for (String s : this.readFileContent()) {
            if (!s.contains("PASSWORD_LOCK_TIME")) continue;
            if (s.split("=")[1].trim().contains("*")) {
                String[] num = s.split("=")[1].trim().split("\\*", 2);
                this.lockTime = Long.valueOf(num[0]) * Long.valueOf(num[1]);
                continue;
            }
            this.lockTime = Long.valueOf(s.split("=")[1].trim());
        }
    }

    public String configData(String key) {
        for (String s : this.readFileContent()) {
            if (!s.contains(key)) continue;
            return s.split("=")[1].trim();
        }
        return null;
    }
}

