/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.auth.service;

import cn.hutool.core.convert.Convert;
import gz.lp.auth.service.SysPasswordService;
import gz.lp.auth.service.SysRecordLogService;
import gz.lp.common.core.api.R;
import gz.lp.common.core.enums.UserStatus;
import gz.lp.common.core.exception.ServiceException;
import gz.lp.common.core.utils.StringUtil;
import gz.lp.common.core.utils.ip.IpUtils;
import gz.lp.common.redis.util.RedisUtil;
import gz.lp.system.api.RemoteUserService;
import gz.lp.system.api.domain.SysUser;
import gz.lp.system.api.model.LoginUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SysLoginService {
    @Autowired
    private RemoteUserService remoteUserService;
    @Autowired
    private SysPasswordService passwordService;
    @Autowired
    private SysRecordLogService recordLogService;

    public LoginUser login(String username, String password) {
        if (StringUtil.isAnyBlank((CharSequence[])new CharSequence[]{username, password})) {
            this.recordLogService.recordLogininfor(username, "Error", "\u7528\u6237/\u5bc6\u7801\u5fc5\u987b\u586b\u5199");
            throw new ServiceException("\u7528\u6237/\u5bc6\u7801\u5fc5\u987b\u586b\u5199");
        }
        if (password.length() < 5 || password.length() > 20) {
            this.recordLogService.recordLogininfor(username, "Error", "\u7528\u6237\u5bc6\u7801\u4e0d\u5728\u6307\u5b9a\u8303\u56f4");
            throw new ServiceException("\u7528\u6237\u5bc6\u7801\u4e0d\u5728\u6307\u5b9a\u8303\u56f4");
        }
        if (username.length() < 2 || username.length() > 20) {
            this.recordLogService.recordLogininfor(username, "Error", "\u7528\u6237\u540d\u4e0d\u5728\u6307\u5b9a\u8303\u56f4");
            throw new ServiceException("\u7528\u6237\u540d\u4e0d\u5728\u6307\u5b9a\u8303\u56f4");
        }
        String blackStr = Convert.toStr((Object)RedisUtil.get((String)"sys_config:sys.login.blackIPList"));
        if (IpUtils.isMatchedIp((String)blackStr, (String)IpUtils.getIpAddr())) {
            this.recordLogService.recordLogininfor(username, "Error", "\u5f88\u9057\u61be\uff0c\u8bbf\u95eeIP\u5df2\u88ab\u5217\u5165\u7cfb\u7edf\u9ed1\u540d\u5355");
            throw new ServiceException("\u5f88\u9057\u61be\uff0c\u8bbf\u95eeIP\u5df2\u88ab\u5217\u5165\u7cfb\u7edf\u9ed1\u540d\u5355");
        }
        R userResult = this.remoteUserService.getUserInfo(username, "inner");
        if (StringUtil.isNull((Object)userResult) || StringUtil.isNull((Object)userResult.getData())) {
            this.recordLogService.recordLogininfor(username, "Error", "\u767b\u5f55\u7528\u6237\u4e0d\u5b58\u5728");
            throw new ServiceException("\u767b\u5f55\u7528\u6237\uff1a" + username + " \u4e0d\u5b58\u5728");
        }
        if ((long)R.FAIL == userResult.getCode()) {
            throw new ServiceException(userResult.getMsg());
        }
        LoginUser userInfo = (LoginUser)userResult.getData();
        SysUser user = ((LoginUser)userResult.getData()).getSysUser();
        if (UserStatus.DELETED.getCode().equals(String.valueOf(user.getDelFlag()))) {
            this.recordLogService.recordLogininfor(username, "Error", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u8d26\u53f7\u5df2\u88ab\u5220\u9664");
            throw new ServiceException("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u8d26\u53f7\uff1a" + username + " \u5df2\u88ab\u5220\u9664");
        }
        String s = this.passwordService.notLoginInFor30Days(((LoginUser)userResult.getData()).getSysUser().getLoginDate(), username);
        if (StringUtil.isNotEmpty((String)s)) {
            userInfo.setMsg(s);
            throw new ServiceException(s);
        }
        if (UserStatus.DISABLE.getCode().equals(user.getStatus())) {
            this.recordLogService.recordLogininfor(username, "Error", "\u7528\u6237\u5df2\u505c\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            throw new ServiceException("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u8d26\u53f7\uff1a" + username + " \u5df2\u505c\u7528");
        }
        String result = this.passwordService.notLoginInFor90Days(((LoginUser)userResult.getData()).getSysUser().getPassUpdate());
        if (StringUtil.isNotEmpty((String)result)) {
            userInfo.setMsg(result);
            return userInfo;
        }
        this.remoteUserService.loginDate(username, "inner");
        this.recordLogService.recordLogininfor(username, "Success", "\u767b\u5f55\u6210\u529f");
        return userInfo;
    }

    public void logout(String loginName) {
        this.recordLogService.recordLogininfor(loginName, "Logout", "\u9000\u51fa\u6210\u529f");
    }
}

