/*
 * Decompiled with CFR 0.152.
 */
package gz.lp.auth.controller;

import gz.lp.auth.service.SysLoginService;
import gz.lp.auth.service.SysPasswordService;
import gz.lp.common.core.api.R;
import gz.lp.common.core.model.LoginBody;
import gz.lp.common.core.utils.StringUtil;
import gz.lp.common.core.utils.jwt.JwtUtils;
import gz.lp.common.core.utils.sign.AesUtils;
import gz.lp.common.security.auth.AuthUtil;
import gz.lp.common.security.service.TokenService;
import gz.lp.common.security.utils.SecurityUtils;
import gz.lp.system.api.model.LoginUser;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TokenController {
    @Autowired
    private TokenService tokenService;
    @Autowired
    private SysPasswordService passwordService;
    @Autowired
    private SysLoginService sysLoginService;

    @PostMapping(value={"login"})
    public R<?> login(@RequestBody LoginBody form) {
        LoginUser userInfo = null;
        try {
            userInfo = this.sysLoginService.login(form.getUsername(), AesUtils.aesDecrypt((String)form.getPassword()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return R.ok((Object)this.tokenService.createToken(userInfo));
    }

    @DeleteMapping(value={"logout"})
    public R<?> logout(HttpServletRequest request) {
        String token = SecurityUtils.getToken((HttpServletRequest)request);
        if (StringUtil.isNotEmpty((String)token)) {
            String username = JwtUtils.getUserName((String)token);
            AuthUtil.logoutByToken((String)token);
            this.sysLoginService.logout(username);
        }
        return R.ok();
    }

    @PostMapping(value={"refresh"})
    public R<?> refresh(HttpServletRequest request) {
        LoginUser loginUser = this.tokenService.getLoginUser(request);
        if (StringUtil.isNotNull((Object)loginUser)) {
            this.tokenService.refreshToken(loginUser);
            return R.ok();
        }
        return R.ok();
    }
}

